
from googleapiclient.discovery import build
from googleapiclient.errors import HttpError
from google.oauth2.credentials import Credentials
import os

def delete_files_in_folder(folder_id, token):
    try:
        creds = Credentials(token=token)
        service = build('drive', 'v3', credentials=creds)

        # List files in the folder
        results = service.files().list(q=f"'{folder_id}' in parents").execute()
        files = results.get('files', [])

        for file in files:
            file_id = file['id']
            file_name = file['name']

            # Delete each file
            service.files().delete(fileId=file_id).execute()
            print(f"Deleted file: {file_name} (ID: {file_id})")

        print("All files deleted successfully.")

    except HttpError as error:
        print(f"An error occurred: {error}")

if __name__ == "__main__":
    import sys
    if len(sys.argv) < 3:
        print("Usage: python delete_files.py <folder_id> <token>")
        sys.exit(1)

    folder_id = sys.argv[1]
    token = sys.argv[2]
    delete_files_in_folder(folder_id, token)
